/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h14199.engine.Session;
import org.h14199.index.Cursor;
import org.h14199.message.DbException;
import org.h14199.result.Row;
import org.h14199.result.SearchRow;
import org.h14199.table.Column;
import org.h14199.table.TableLink;
import org.h14199.value.DataType;
import org.h14199.value.Value;

public class LinkedCursor
implements Cursor {
    private final TableLink tableLink;
    private final PreparedStatement prep;
    private final String sql;
    private final Session session;
    private final ResultSet rs;
    private Row current;

    LinkedCursor(TableLink tableLink, ResultSet resultSet, Session session, String string, PreparedStatement preparedStatement) {
        this.session = session;
        this.tableLink = tableLink;
        this.rs = resultSet;
        this.sql = string;
        this.prep = preparedStatement;
    }

    @Override
    public Row get() {
        return this.current;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.current;
    }

    @Override
    public boolean next() {
        int n;
        try {
            n = this.rs.next();
            if (n == 0) {
                this.rs.close();
                this.tableLink.reusePreparedStatement(this.prep, this.sql);
                this.current = null;
                return false;
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        this.current = this.tableLink.getTemplateRow();
        for (n = 0; n < this.current.getColumnCount(); ++n) {
            Column column = this.tableLink.getColumn(n);
            Value value = DataType.readValue(this.session, this.rs, n + 1, column.getType().getValueType());
            this.current.setValue(n, value);
        }
        return true;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

